﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;

namespace DMX_Revolution
{
    public partial class Settings : Form
    {
        SerialPort pnames;

        public Settings()
        {
            InitializeComponent();
            listBox1.Items.Clear();
        }

        //public event EventHandler SetChange;
        public event EventHandler<SetChangeEventArgs> SetChange;

        //Exit EventArgs
        public event EventHandler exit;
        

        //Die Ports aus der Liste werden für die weitere verarbeitung gekapselt.

        public string Port
        {
            get { return listBox1.SelectedItem.ToString(); }
        }

        //Auswahl des Ports

        private void button1_Click(object sender, EventArgs e)
        {
            if (listBox1.SelectedItem != null)
            {
                SetChange(this, new SetChangeEventArgs(Port));
                this.Close();
            }
            else
            {
                MessageBox.Show("Bitte ein Interface angeben");
            }
        }



        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (listBox1.SelectedItem !=null)
                label1.Text = listBox1.SelectedItem.ToString();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            listBox1.Items.Clear();
            listBox1.Items.AddRange(SerialPort.GetPortNames());
        }

        private void quit_Click(object sender, EventArgs e)
        {
            SetChange(this, new SetChangeEventArgs("exit"));
            this.Close();
        }


    }


    //Eigene EventArgs wodurch der COM Port in das andere Fenster übertragen wird.
    public class SetChangeEventArgs : EventArgs
    {
        string portname;

        public string Portname
        {
            get { return portname; }
            set { portname = value; }
        }

        public SetChangeEventArgs(string port)
        {
            portname = port;
        }
    }


    //Eigene EventArgs wodurch ein boolscher Bestätigungswert an das Hauptfenster geschickt wird.
    public class OkayEventArgs : EventArgs
    {
        bool okay;

        public bool Okay
        {
            get { return okay; }
            set { okay = value; }
        }

        public OkayEventArgs(bool ok)
        {
            okay = ok;
        }

    }
}
